local super = require "TableColumn"

BubbleColumn = super:new()

local defaults = {
    max = 100,
}

local nilDefaults = {
    'value', 'paint',
}

local getterNames = {'max', 'value', 'paint'}

local inspectorInfo = {
    {'number', {'max'}, 'Max'},
    {'KeyArtifact', {'value'}, 'Value'},
    {'Color', {'getPaint:setPaint', custom = 'hasExplicitPaint:'}, 'Color'},
}

function BubbleColumn:new()
    self = super.new(self)
    
    for k, v in pairs(defaults) do
        self:addProperty(k, v)
    end
    for _, k in pairs(nilDefaults) do
        self:addProperty(k)
    end
    
    self.stamp = BubbleStamp
    self.getterNames = getterNames
    self.inspectorInfo = inspectorInfo
    
    return self
end

function BubbleColumn:unarchived()
    local dataset = self:getDataset()
    if dataset then
        if self:getProperty('value') == nil then
            local avoidingFields = self:peerPropertyKeyArtifactValues(BubbleColumn, 'value')
            local field = dataset:pickField('number', avoidingFields)
            if field then
                self:setProperty('value', KeyArtifact:new(field))
                self:setTitle(field)
            end
        end
    end
    super.unarchived(self)
end

function BubbleColumn:drawCell(canvas, rect, max, value, paint)
    rect = rect:insetXY(0, rect:height() / 12)
    BubbleStamp(canvas, rect, max, value, paint or self:getParent():getAccentPaint())
end

function BubbleColumn:getDefaultPaint()
    return self:getParent():getAccentPaint()
end

return BubbleColumn
